local c;
local player = Var "Player";

local JudgeCmds = {
	TapNoteScore_W1 = THEME:GetMetric( "Judgment", "JudgmentW1Command" );
	TapNoteScore_W2 = THEME:GetMetric( "Judgment", "JudgmentW2Command" );
	TapNoteScore_W3 = THEME:GetMetric( "Judgment", "JudgmentW3Command" );
	TapNoteScore_W4 = THEME:GetMetric( "Judgment", "JudgmentW4Command" );
	TapNoteScore_W5 = THEME:GetMetric( "Judgment", "JudgmentW5Command" );
	TapNoteScore_Miss = THEME:GetMetric( "Judgment", "JudgmentMissCommand" );
};

local ProtimingCmds = {
	TapNoteScore_W1 = THEME:GetMetric( "Protiming", "ProtimingW1Command" );
	TapNoteScore_W2 = THEME:GetMetric( "Protiming", "ProtimingW2Command" );
	TapNoteScore_W3 = THEME:GetMetric( "Protiming", "ProtimingW3Command" );
	TapNoteScore_W4 = THEME:GetMetric( "Protiming", "ProtimingW4Command" );
	TapNoteScore_W5 = THEME:GetMetric( "Protiming", "ProtimingW5Command" );
	TapNoteScore_Miss = THEME:GetMetric( "Protiming", "ProtimingMissCommand" );
};

local TNSFrames = {
	TapNoteScore_W1 = 0;
	TapNoteScore_W2 = 1;
	TapNoteScore_W3 = 2;
	TapNoteScore_W4 = 3;
	TapNoteScore_W5 = 4;
	TapNoteScore_Miss = 5;
};
local function ShowProtiming()
  if GAMESTATE:IsDemonstration() then
    return false
  else
    return GetUserPrefB("UserPrefProtiming" .. ToEnumShortString(player));
  end
end;
local tm=PREFSMAN:GetPreference("TimingWindowSecondsW3")
local bShowProtiming = ShowProtiming();
local t = Def.ActorFrame {};
t[#t+1] = Def.ActorFrame {

	LoadFont("Common Normal") .. {
		Name="Js";
		OnCommand =cmd(y,15;shadowlength,4;zoomy,1.4;zoomx,1.4*1.2;diffusebottomedge,color("0,0.75,0.75,1");strokecolor,color("0.75,0.75,0.75,1");skewx,-0.1;);
		ResetCommand=cmd(finishtweening;stopeffect;y,20;x,0;visible,false);
		JudgmentMessageCommand=function(self,param)
			if param.Player ~= player then return end;
			if param.HoldNoteScore then return end;

			local iNumStates =6
			local iFrame = TNSFrames[param.TapNoteScore];
		
			if not iFrame then return end
			self:playcommand("Reset");
			if iFrame==0 then
				self:settext("Flawless!");
				self:diffusebottomedge(color("0,0.75,0.9,1"));
				(cmd(diffusealpha,1;zoomy,1.4*1.3;zoomx,1.4*1.2*1.3;linear,0.05;zoomy,1.4;zoomx,1.4*1.2;sleep,0.8;linear,0.1;zoomy,0.7;zoomx,1.4*0.6;diffusealpha,0;glowblink;effectperiod,0.05;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.25")))(self)
			elseif iFrame==1 then
				self:settext("Perfect");
				self:diffusebottomedge(color("1,0.75,0.2,1"));
				(cmd(diffusealpha,1;zoomy,1.4*1.3;zoomx,1.4*1.2*1.3;linear,0.05;zoomy,1.4;zoomx,1.4*1.2;sleep,0.8;linear,0.1;zoomy,0.7;zoomx,1.4*0.6;diffusealpha,0))(self)
			elseif iFrame==2 then
				self:settext("Great");
				self:diffusebottomedge(color("0,0.9,0.2,1"));
				(cmd(diffusealpha,1;zoomy,1.4*1.3;zoomx,1.4*1.2*1.3;linear,0.05;zoomy,1.4;zoomx,1.4*1.2;sleep,0.8;linear,0.1;zoomy,0.7;zoomx,1.4*0.6;diffusealpha,0))(self)
			elseif iFrame==3 then
				self:settext("Good");
				self:diffusebottomedge(color("0,0.75,0.6,1"));
				(cmd(diffusealpha,1;zoomy,1.4*1.3;zoomx,1.4*1.2*1.3;linear,0.05;zoomy,1.4;zoomx,1.4*1.2;sleep,0.8;linear,0.1;zoomy,0.7;zoomx,1.4*0.6;diffusealpha,0))(self)
			elseif iFrame==4 then
				self:settext("Bad");
				self:diffusebottomedge(color("1,0,0,1"));
				(cmd(diffusealpha,1;zoomy,1.4;zoomx,1.4*1.2;vibrate;effectmagnitude,4,8,8;sleep,0.8;linear,0.1;zoomy,0.7;zoomx,1.4*0.6;diffusealpha,0))(self)
			elseif iFrame==5 then
				self:settext("Miss..");
				self:diffusebottomedge(color("1,0,0,1"));
				(cmd(diffusealpha,1;zoomy,1.4;zoomx,1.4*1.2;x,0;linear,0.8;x,60;sleep,0.8;linear,0.1;zoomy,0.7;zoomx,1.4*0.6;diffusealpha,0))(self)
			else
				self:settext("Huh?");
				self:diffusebottomedge(color("1,1,1,1"));
			end;
	
			self:visible(true);
	end;
	};

 	LoadFont("Common normal")..{
		Text="";
		InitCommand=cmd(y,-14;x,-120;skewx,-0.1;zoom,1;visible,false;halign,1;);
		OnCommand=cmd(diffusebottomedge,color("#898989");diffusealpha,1;linear,0.5;diffusealpha,1;strokecolor,color("#000000"););
		OffCommand=cmd(linear,0.5;diffusealpha,0);
		ResetCommand=cmd(finishtweening;stopeffect;visible,false);
		JudgmentMessageCommand=function(self,param)
			if bShowProtiming then
				if param.Player ~= player then return end;
				if param.HoldNoteScore then return end;
				if (GAMESTATE:GetPlayerState(param.Player):GetPlayerController()=='PlayerController_Autoplay') then return end;
					--local iTapNoteOffset = param.TapNoteOffset;
					--iTapNoteOffset=iTapNoteOffset*1000
					self:playcommand("Reset");
					self:visible(1);
					self:settext( string.format("%i",param.TapNoteOffset*1000).."ms");
			end;
		end;
	};
};
t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(y,-14;zoomy,0.5;visible,bShowProtiming);
		LoadActor("protiming fill") .. {
			InitCommand=cmd(zoom,1;cropleft,0.5;cropright,0.5;blend,Blend.Add;);
			ResetCommand=cmd(finishtweening;stoptweening;visible,false);
			JudgmentMessageCommand=function(self,param)
				if bShowProtiming then
					if param.Player ~= player then return end;
					if param.HoldNoteScore then return end;
					if (GAMESTATE:GetPlayerState(param.Player):GetPlayerController()=='PlayerController_Autoplay') then return end;
						local iTapNoteOffset = param.TapNoteOffset;
						self:playcommand("Reset");
						self:visible(1);
						if math.abs(iTapNoteOffset)< tm then
							if iTapNoteOffset>0 then
								self:cropleft(0.5);
								self:cropright(0.5-0.5*(math.abs(iTapNoteOffset))/tm);
							elseif iTapNoteOffset<0 then
								self:cropright(0.5);
								self:cropleft(0.5-0.5*(math.abs(iTapNoteOffset))/tm);
							else
								self:cropright(0.5);
								self:cropleft(0.5);
							end;
						elseif math.abs(iTapNoteOffset)> tm then
							if iTapNoteOffset>0 then
								self:cropleft(0.5);
								self:cropright(0);
							elseif iTapNoteOffset<0 then
								self:cropright(0.5);
								self:cropleft(0);
							else
								self:cropright(0.5);
								self:cropleft(0.5);
							end;
						else
							self:cropright(0.5);
							self:cropleft(0.5);
						end;
				end;
			end;
		};
		LoadActor("protiming over") .. {
			InitCommand=cmd(zoom,1;);
		};
		LoadActor("protiming bar") .. {
			InitCommand=cmd(zoom,1;);
		};
};
return t;